/*
  ==============================================================================

  This is an automatically generated GUI class created by the Introjucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Introjucer version: 3.1.0

  ------------------------------------------------------------------------------

  The Introjucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-13 by Raw Material Software Ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...

#include "MainComponent.h"
#include "Patcher.h"

//[/Headers]

#include "PatcherPanel.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
PatcherPanel::PatcherPanel (MainContentComponent& mainComp)
    : mainComponent(mainComp)
{
    addAndMakeVisible (patchViewport = new Viewport ("patchViewport"));
    patchViewport->setViewedComponent (new Patcher(mainComponent));

    addAndMakeVisible (addListenPortButton = new TextButton ("addListenPortButton"));
    addListenPortButton->setButtonText ("Add Listen Port");
    addListenPortButton->addListener (this);

    addAndMakeVisible (addSendPortButton = new TextButton ("addSendPortButton"));
    addSendPortButton->setButtonText ("Add Send Port");
    addSendPortButton->addListener (this);


    //[UserPreSize]
    //[/UserPreSize]

    setSize (600, 400);


    //[Constructor] You can add your own custom stuff here..
    //[/Constructor]
}

PatcherPanel::~PatcherPanel()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    patchViewport = nullptr;
    addListenPortButton = nullptr;
    addSendPortButton = nullptr;


    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void PatcherPanel::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.fillAll (Colour (0xffeeece1));

    g.setColour (Colour (0x60000000));
    g.fillRect (7, 7, getWidth() - 14, getHeight() - 46);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void PatcherPanel::resized()
{
    patchViewport->setBounds (8, 8, getWidth() - 16, getHeight() - 48);
    addListenPortButton->setBounds (8, getHeight() - 32, 128, 24);
    addSendPortButton->setBounds (getWidth() - 136, getHeight() - 32, 128, 24);
    //[UserResized] Add your own custom resize handling here..

	int newWidth = patchViewport->getMaximumVisibleWidth();
	int newHeight = patchViewport->getMaximumVisibleHeight();
	Component *patcher(patchViewport->getViewedComponent());

	patcher->setSize(jmax(patcher->getWidth(), newWidth),
					 jmax(patcher->getHeight(), newHeight));

    //[/UserResized]
}

void PatcherPanel::buttonClicked (Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]

    Patcher *patcher(dynamic_cast<Patcher *>(patchViewport->getViewedComponent()));

    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == addListenPortButton)
    {
        //[UserButtonCode_addListenPortButton] -- add your button handler code here..

        if(patcher)
            patcher->addListenPort("", "");

        //[/UserButtonCode_addListenPortButton]
    }
    else if (buttonThatWasClicked == addSendPortButton)
    {
        //[UserButtonCode_addSendPortButton] -- add your button handler code here..

		if(patcher)
            patcher->addSendPort("", "", "");

        //[/UserButtonCode_addSendPortButton]
    }

    //[UserbuttonClicked_Post]
    //[/UserbuttonClicked_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...

//------------------------------------------------------------------------------
void PatcherPanel::addGame(const String& gameName,
						   const String& listenPort,
						   const String& sendAddress,
						   const String& sendPort)
{
	Patcher *patcher(dynamic_cast<Patcher *>(patchViewport->getViewedComponent()));

	if(patcher)
	{
		//sendAddress will always be 127.0.0.1 because it's run from the same
		//machine.
		patcher->addSendPort(gameName, "127.0.0.1", listenPort);
		patcher->addListenPort(gameName, sendPort);
	}
}

//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Introjucer information section --

    This is where the Introjucer stores the metadata that describe this GUI layout, so
    make changes in here at your peril!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="PatcherPanel" componentName=""
                 parentClasses="public Component" constructorParams="MainContentComponent&amp; mainComp"
                 variableInitialisers="mainComponent(mainComp)" snapPixels="8"
                 snapActive="1" snapShown="1" overlayOpacity="0.330000013" fixedSize="0"
                 initialWidth="600" initialHeight="400">
  <BACKGROUND backgroundColour="ffeeece1">
    <RECT pos="7 7 14M 46M" fill="solid: 60000000" hasStroke="0"/>
  </BACKGROUND>
  <VIEWPORT name="patchViewport" id="fac243dc052d268a" memberName="patchViewport"
            virtualName="" explicitFocusOrder="0" pos="8 8 16M 48M" vscroll="1"
            hscroll="1" scrollbarThickness="18" contentType="2" jucerFile=""
            contentClass="Patcher" constructorParams=""/>
  <TEXTBUTTON name="addListenPortButton" id="b1a913c9ed14f519" memberName="addListenPortButton"
              virtualName="" explicitFocusOrder="0" pos="8 32R 128 24" buttonText="Add Listen Port"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
  <TEXTBUTTON name="addSendPortButton" id="4b85d220c0400505" memberName="addSendPortButton"
              virtualName="" explicitFocusOrder="0" pos="136R 32R 128 24" buttonText="Add Send Port"
              connectedEdges="0" needsCallback="1" radioGroupId="0"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif


//[EndFile] You can add extra defines here...
//[/EndFile]
